//
//  WXKProgressWindowController.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/07/23.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKProgressWindowController.h"


@implementation WXKProgressWindowController


#pragma mark Class methods

+ (id)sharedWindowControllerWithParentWindow:(NSWindow *)window
{
	static WXKProgressWindowController *sharedWindowController;
	
	if (!sharedWindowController) {
		sharedWindowController = [[WXKProgressWindowController alloc] initWithParentWindow:window];
	}
	return sharedWindowController;
}

#pragma mark Initialization methods

- (id)initWithParentWindow:(NSWindow *)window
{
	self = [super initWithWindowNibName:@"ProgressWindow"];
	if (self) {
		session				= NULL;
		isRequestedToAbort	= NO;
		parentWindow		= window; // weak reference (not retain) to parent window
	}
	return self;
}

- (void)dealloc
{
	if (session) {
		[self endProgress];
	}
	[super dealloc];
}

#pragma mark Action methods

//- (void)cancelOperation:(id)sender
//{
//	isRequestedToAbort = YES;
//}

- (IBAction)requestToAbortProgress:(id)sender
{
	isRequestedToAbort = YES;
}


#pragma mark Protocol of WXKProgressing

// -- Set the proggress indicator to indeterminate mode, begin modal session, and Show the window.

- (void)beginProgressWithMessage:(NSString *)message
{
	isRequestedToAbort = NO;
	
	[self window]; // If the nib file has not yet loaded, load the nib file.
	
	if(message == nil) {
		[messageTextField setStringValue:NSLocalizedString(@"Communicating...", nil)];
	} else {
		[messageTextField setStringValue:message];
	}
	
	[countTextField setHidden:YES];
	
	[progressIndicator setIndeterminate:YES];
	[progressIndicator setUsesThreadedAnimation:YES];
	[progressIndicator startAnimation:self];
	
	[NSApp beginSheet:[self window]
	   modalForWindow:parentWindow
		modalDelegate:self
	   didEndSelector:NULL
		  contextInfo:NULL];
	
	session = [NSApp beginModalSessionForWindow:[self window]];
	[NSApp runModalSession:session];
}

- (void)setMessage:(NSString *)message
{
	[messageTextField setStringValue:message];
	if (session) {
		[NSApp runModalSession:session];
	}
}


// -- Set the proggress indicator to determinate mode and begin to progress.

- (void)startDeterminateProgressWithMaxValue:(double)maxValue message:(NSString *)message
{
	[progressIndicator setDoubleValue:0.0];
	[progressIndicator setMaxValue:maxValue];
	[progressIndicator setIndeterminate:NO];
	
	[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	[countTextField setHidden:NO];
	
	if (message) {
		[messageTextField setStringValue:message];
	}
	
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- Refresh the progress window. ---

- (void)updateDoubleValue:(double)value message:(NSString *)message
{
	if (value > 0) {
		[progressIndicator setDoubleValue:value];
		[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	}
	if (message) {
		[messageTextField setStringValue:message];
	}
	[[self window] displayIfNeeded];
	
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- Refresh the progress window. ---

- (void)incrementProgressBarBy:(double)value
{
	[progressIndicator incrementBy:value];
	[countTextField setStringValue:[NSString stringWithFormat:@"%d/%d", (int)[progressIndicator doubleValue], (int)[progressIndicator maxValue]]];
	[[self window] displayIfNeeded];
	
	if (session) {
		[NSApp runModalSession:session];
	}
}

// --- Return YES when user requested to abort. ---

- (BOOL)isRequestedToAbort
{
	return isRequestedToAbort;
}


// --- End the session and close the progress window. ---

- (void)endProgress
{
	if (session) {
		[[self window] displayIfNeeded];
		[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.5]];
		// Wait a while so that the progress indicator finishes filling the bar.
		// There might exist the better way to refreshing the window
		
		[progressIndicator stopAnimation:self];
		[NSApp endModalSession:session];
		[NSApp endSheet:[self window]];
		[[self window] orderOut:self];
		
		session = NULL;
		isRequestedToAbort = NO;
		
		[NSApp requestUserAttention:NSInformationalRequest];
	}
}


@end
